%% MU MIMO multi plotter

clear all
close all
clc

load('MU_multi_K_8L_3Nr_128.mat')

figure
plot(SNR_dB , 10.*log10(Channel_MSE_analog), 'm--o','LineWidth',1.2);
hold on
plot(SNR_dB , 10.*log10(Channel_MSE_analog_s), 'r--d','LineWidth', 1.2);
hold on
plot(SNR_dB , 10.*log10(Channel_MSE_sd_lee), 'c-.^','LineWidth',1.2);
hold on
plot(SNR_dB ,  10.*log10(Channel_MSE_sd_Gray), 'b-s','LineWidth', 1.2);
hold on
plot(SNR_dB , 10.*log10(Channel_MSE_ob_blmmse), 'k-.*','LineWidth',1.2);
grid on

legend('UQ - LMMSE','UQ - angular','SD - Bussgang', 'SD - proposed','BLMMSE');

xlabel('SNR (dB)');
ylabel('MSE (dB)');
legend('location','southwest')
savefig('MUMIMO_multi_K8_128.fig')
saveas(gcf,'MUMIMO_multi_K8_128','epsc')

%%

load('MU_multi_K_8L_3Nr_256.mat')

figure
plot(SNR_dB , 10.*log10(Channel_MSE_analog), 'm--o','LineWidth',1.2);
hold on
plot(SNR_dB , 10.*log10(Channel_MSE_analog_s), 'r--d','LineWidth', 1.2);
hold on
plot(SNR_dB , 10.*log10(Channel_MSE_sd_lee), 'c-.^','LineWidth',1.2);
hold on
plot(SNR_dB ,  10.*log10(Channel_MSE_sd_Gray), 'b-s','LineWidth', 1.2);
hold on
plot(SNR_dB , 10.*log10(Channel_MSE_ob_blmmse), 'k-.*','LineWidth',1.2);
grid on

legend('UQ - LMMSE','UQ - angular','SD - Bussgang', 'SD - proposed','BLMMSE');

xlabel('SNR (dB)');
ylabel('MSE (dB)');
legend('location','southwest')
savefig('MUMIMO_multi_K8_256.fig')
saveas(gcf,'MUMIMO_multi_K8_256','epsc')

%% Genie plot

% K = 8
load('5MU_multi_Genie_K_8.mat')

figure
plot(SNR_dB , 10.*log10(Channel_MSE_analog), 'm--o','LineWidth',1.2);
hold on
plot(SNR_dB , 10.*log10(Channel_MSE_analog_s), 'r--d','LineWidth', 1.2);
hold on
plot(SNR_dB , 10.*log10(Channel_MSE_sd_lee), 'c-.^','LineWidth',1.2);
hold on
plot(SNR_dB ,  10.*log10(Channel_MSE_sd_Gray), 'b-s','LineWidth', 1.2);
hold on
plot(SNR_dB , 10.*log10(Channel_MSE_ob_blmmse), 'k-.*','LineWidth',1.2);
grid on

legend('UQ - LMMSE','UQ - angular','SD - Bussgang', 'SD - proposed','BLMMSE');

xlabel('SNR (dB)');
ylabel('MSE (dB)');
legend('location','southwest')

savefig('MUMIMO_multi_K8_128_genie.fig')
saveas(gcf,'MUMIMO_multi_K8_128_genie','epsc')

%% LoS


load('LoS_MU_multi_K_8L_1Nr_128.mat')

figure
plot(SNR_dB , 10.*log10(Channel_MSE_analog), 'm--o','LineWidth',1.2);
hold on
plot(SNR_dB , 10.*log10(Channel_MSE_analog_s), 'r--d','LineWidth', 1.2);
hold on
plot(SNR_dB , 10.*log10(Channel_MSE_sd_lee), 'c-.^','LineWidth',1.2);
hold on
plot(SNR_dB ,  10.*log10(Channel_MSE_sd_Gray), 'b-s','LineWidth', 1.2);
hold on
plot(SNR_dB , 10.*log10(Channel_MSE_ob_blmmse), 'k-.*','LineWidth',1.2);
grid on

legend('UQ - LMMSE','UQ - angular','SD - Bussgang', 'SD - proposed','BLMMSE');

xlabel('SNR (dB)');
ylabel('MSE (dB)');
legend('location','southwest')

savefig('LoS_MUMIMO_multi_K8_128.fig')
saveas(gcf,'LoS_MUMIMO_multi_K8_128','epsc')
